function report_results(M_name)

% Displays the results recorded in plr (passed on as global).  
% M_name is a string that records the name of M to be used in the display.

% global variables

global beta plr Pr_data x_data n NA NY NW jstate

% report belief sets

disp(' ')
disp('1. The relevant belief sets are:')
disp(' ')

for i=1:2
  
    for wi=1:NW(i)
        
        % number to string conversion
        
        i_s = num2str(i);
        ni_s = num2str(n(i));
        wi_s = num2str(wi);
        
        % report beleif set
        
        if (plr(i).M(wi).emp==1) 
          
          disp([' ',M_name,'_',i_s,'(w',i_s,'=',wi_s,') = empty set'])
        
        else
          
          n_ext = size(plr(i).M(wi).ext,1);
          
          disp([' ',M_name,'_',i_s,'(w',i_s,'=',wi_s,...
                ') = convex hull of the following ',...
                num2str(n_ext),' extreme points:'])
          
          for j=1:n_ext
              
            disp([' (',num2str(j),') ',num2str(plr(i).M(wi).ext(j,:),'%11.4f')])
              
          end
            
        end
    
        disp(' ')    
        
    end
    
    disp(' ')
    
end

% report incentives

disp('2. Evaluation of incentives:')
disp(' ')

nicv = 0; % number of ic violations

for i=1:2; for wi=1:NW(i); for ai=1:NA(i); for j=1:size(plr(i).M(wi).ext,1)
            
        if (plr(i).ic(wi).dd(ai,j)==1) % report ic violation 

            % number-to-string conversion

            i_s = num2str(i);
            ni_s = num2str(n(i));
            wi_s = num2str(wi);
            ai_s = num2str(ai);
            j_s = num2str(j);
            
            % display results

            disp([' Player ',i_s,' has the incentive to deviate to a',...
                  i_s,'=',ai_s,' in state w',i_s,'=',wi_s'])
            disp([' when his belief is extreme point (',j_s,') in ',...
                  M_name,'_',i_s]);
            disp(' ')                
            
            % count ic violation
            
            nicv = nicv + 1;
            
        end
                    
end; end; end; end

if (nicv==0) % all incentives hold
  
    disp(' All incentives hold.')
    disp(' ')  
  
end


